// Example 3b: Single LEDs
#include <hidef.h>      /* common defines and macros */
#include <mc9s12dg256.h>     /* derivative information */
#pragma LINK_INFO DERIVATIVE "mc9s12dg256b"

#include "main_asm.h" /* interface to the assembly module */

void main(void) {
  PLL_init();           // set system clock frequency to 24 MHz
  led_enable();         // enable LEDs
  seg7_disable();       // disable 7-segment displays
  while(1){
    led_on(0);         	// turn on LED 0
    ms_delay(500);		// half-second delay
    led_on(2);        	// turn on LED 2
    ms_delay(500);		// half-second delay
    led_on(4);       	// turn on LED 3
    ms_delay(500);		// half-second delay
    led_off(0);       	// turn off LED 0
    ms_delay(500);		// half-second delay
    led_off(2);        	// turn off LED 2
    ms_delay(500);		// half-second delay
    led_off(4);        	// turn off LED 4
    ms_delay(500);		// half-second delay

  }
}






